#! /usr/local/bin/python

########################################
#See Readme file for description
########################################

#load modules required for this script
import numpy #for array manipulation 
import pylab #for plotting
import scipy.stats #constains function for percentile calcuations
from scipy.interpolate import interp1d #contains interpolation function
from matplotlib import rc #for special characters in figure labels

#create time vector with same start year, end year, and number of elements as forg curves loaded from file
t=numpy.linspace(5,3600,1000) 

#This section plots forg results
pylab.figure() #create figure

#load smoothed LOWESS curves from file
mega_f=numpy.load("mega_f_LOWESS.npy") #this numpy array must first be created in forg_LOWESS
#create vectors for 2.5% percentile, median and 95% percentile curves
confidence_f=scipy.stats.scoreatpercentile(mega_f,[2.5,50,97.5], interpolation_method='fraction',axis=0) 
pylab.plot(t,confidence_f[1],'b',linewidth=2) #plot median smoothed forg curve in blue
pylab.xlabel("time (Ma)") #label x axis
pylab.fill_between(t,confidence_f[2], confidence_f[0],alpha=0.2,facecolor="blue") #fill 95% confidence interval blue

#load smoothed Kernel regression curves from file
mega_f=numpy.load("mega_f_KERNEL.npy") #this numpy array must first be created in forg_Kernel
#create vectors for 2.5% percentile, median and 95% percentile curves
confidence_f=scipy.stats.scoreatpercentile(mega_f,[2.5,50,97.5], interpolation_method='fraction',axis=0)
pylab.plot(t,confidence_f[0],'r--',linewidth=2) #plot lower bound of 95% confidence interval dashed red
pylab.plot(t,confidence_f[1],'r',linewidth=2) #plot median smoothed forg curve in red
pylab.plot(t,confidence_f[2],'r--',linewidth=2) #plot upper bound of 95% confidence interval dashed red
pylab.ylabel(r"$f_{org}$",size=16) #y axis label
pylab.xlabel("time (Ma)") #x axis label

pylab.grid() #create grid in figure
pylab.ylim(0,0.4) #x axis limits of figure
pylab.xlim(0,3600) #y axis limits of figure

##########
####This section plots the organic and carbonate results separately

##load filtered, 10my binned data:
carb_filt=numpy.ones(shape=(len(numpy.load("carb_10my_t.npy")),2))
carb_filt[:,0]=numpy.load("carb_10my_t.npy") #time values for carbonates
carb_filt[:,1]=numpy.load("carb_10my_v.npy") #isotope values for carbonates
org_filt=numpy.ones(shape=(len(numpy.load("org_10my_t.npy")),2))
org_filt[:,0]=numpy.load("org_10my_t.npy") #time values for organics
org_filt[:,1]=numpy.load("org_10my_v.npy") #isotope values for organics

#rename 
data1=org_filt #organic time and isotopes
data2=carb_filt #carbonate time and isotopes  

# now load arrays with smoothed carbonate and orgnic curves
organic_array_LOWESS=numpy.load("org_array_LOWESS.npy") #LOWESS smoothed organics
carb_array_LOWESS=numpy.load("carb_array_LOWESS.npy") #LOWESS smoothed carbonates
organic_array_KERNEL=numpy.load("org_array_KERNEL.npy") #Kernel smoothed organics
carb_array_KERNEL=numpy.load("carb_array_KERNEL.npy") #Kernel smoothed carbonates

#####################
#Plot organic results
pylab.figure() #create figure
pylab.plot(data1[:,0],data1[:,1],'kx') #plot original data black crosses
#create vectors for 2.5% percentile, median and 95% percentile curves
confidence=scipy.stats.scoreatpercentile(organic_array_LOWESS,[2.5,50,97.5], interpolation_method='fraction',axis=0)  
pylab.plot(data1[:,0],confidence[1],'b') #plot median LOWESS curve as blue line
pylab.fill_between(data1[:,0],confidence[2], confidence[0],alpha=0.2,facecolor="blue") #fill 95% LOWESS confidence interval blue

#now plot smoothed Kernel regressoin results on same figure for comparison
confidence_o=scipy.stats.scoreatpercentile(organic_array_KERNEL,[2.5,50,97.5], interpolation_method='fraction',axis=0)  
pylab.plot(data1[:,0],confidence_o[0],'r--') #lower bound of 95% confidence interval Kernel regression, red dashed line
pylab.plot(data1[:,0],confidence_o[1],'r') #median smoothed Kernel regression curve, red line
pylab.plot(data1[:,0],confidence_o[2],'r--') #upper bound of 95% confidence interval Kernel regression, red dashed line

pylab.xlim(0,3800) # x axis limits
pylab.ylabel(r"$\delta^{13}C_{org}$",size=18) #y axis label
pylab.xlabel("time (Ma)") # x axis label
pylab.grid() #add grid to figure

#######################
#plot carbonate results
pylab.figure() #create figure
pylab.plot(data2[:,0],data2[:,1],'kx') #plot original data black crosses
#create vectors for 2.5% percentile, median and 95% percentile curves
confidence=scipy.stats.scoreatpercentile(carb_array_LOWESS,[2.5,50,97.5], interpolation_method='fraction',axis=0)  
pylab.plot(data2[:,0],confidence[1],'b') #plot median LOWESS curve as blue line
pylab.fill_between(data2[:,0],confidence[2], confidence[0],alpha=0.2,facecolor="blue") #fill LOWESS regression 95% confidence interval blue

#now plot smoothed Kernel regression results on same figure for comparison
confidence_c=scipy.stats.scoreatpercentile(carb_array_KERNEL,[2.5,50,97.5], interpolation_method='fraction',axis=0)  
pylab.plot(data2[:,0],confidence_c[0],'r--') #lower bound of 95% confidence interval Kernel regression, red dashed line
pylab.plot(data2[:,0],confidence_c[1],'r') #median smoothed Kernel regression curve, red line
pylab.plot(data2[:,0],confidence_c[2],'r--') #upper bound of 95% confidence interval Kernel regression, red dashed line

pylab.xlim(0,3600) # x axis limits
pylab.ylabel(r"$\delta^{13}C_{carb}$",size=18) #y axis label
pylab.xlabel("time (Ma)") # x axis label
pylab.grid() #add grid to figure

#show all figures
pylab.show()
import sys
sys.exit()
