#! /usr/local/bin/python
import numpy

########################################
# This function performs classical GLS regression 
# See appendix A.1 for detailed theory

# This function takes as inputs:
# t: time vector in correct matrix format
# Y: carbon isotope values in correct matrix format
# S: estimated error from iterative calculation in GLS_shell
# V: estimated covariance matrix from iterative calculation in GLS_shell
# Tau: estimated time constant from iterative calculation in GLS_shell

# If successful, the function returns the best fit gradient and intercept with respective errors, and a fit parameter
# If unsuccessful, the function returns -9999 fill values for all parameters
########################################

def GLS(t,Y,S,V,Tau):
    
    # convert inputs to matrices for martrix calculations below
    x=numpy.matrix(Y)        
    V=numpy.matrix(V)
    t=numpy.matrix(t)
    
    # check to ensure everything is finite
    if numpy.all(numpy.isfinite(V))==True:
        if numpy.all(numpy.isfinite(numpy.matrix.getI(V)))==True:
            if numpy.all(numpy.isfinite(numpy.transpose(t)*numpy.matrix.getI(V)*t))==True:
                
                #break equation A.2 into two parts
                first=numpy.matrix.getI(numpy.transpose(t)*numpy.matrix.getI(V)*t)
                second=numpy.transpose(t)*numpy.matrix.getI(V)*x
                B=first*second #equation A.2
                
                #error term
                SSQG=numpy.transpose(x-t*B) * numpy.matrix.getI(V) * (x-t*B)
                SSQG=SSQG[0,0]
    
                #get uncerainties in gradient and intercept
                C=numpy.matrix.getI(numpy.transpose(t)*numpy.matrix.getI(V)*t) #equation A.5
                er2=numpy.sqrt(C[0,0])
                er1=numpy.sqrt(C[1,1])
                return B[1,0],B[0,0],er1,er2,SSQG 
                #return best fit intercept, gradient, error in intercept, error in gradient, fit parameter, respectively
                
    else: # if any operations undefined, return fill error values
        return -9999,-9999,-9999,-9999,-9999
    