#! /usr/local/bin/python
import numpy

########################################
# This function takes the following inputs
# oc: determines whether organic ("o") or carbonate ("c") data should be loaded
# start and finish: date for time series (normally 0 and 4000 Ma, respectively).

# It returns the specified data as two numpy arrays, one for the time axies (time)
# and the other for the isotope values (val)
########################################

def draw(oc,start,finish): 
    
    if oc=="o": #load binned organic data from file
        time=numpy.load("org_10my_t.npy")
        val=numpy.load("org_10my_v.npy")
    elif oc=="c": #load binned carbonate data from file
        time=numpy.load("carb_10my_t.npy")
        val=numpy.load("carb_10my_v.npy")
    else:
        print "invalid carb/org choice (c or o only)"
    
    
    # restrict year range (generally not necessary)
    start_year=start
    finish_year=finish
    
    i=0
    strt_index=0
    while i<len(time[:]): #loop over all data
        if time[i]>=start_year: #stop loop when reach the start date specified above
            strt_index=i
            i=99999
        i=i+1
    
    i=0
    fin_index=0
    while i<len(time[:]):
        if (time[i]>finish_year): #stop loop when reach the end date specified above
            fin_index=i
            i=99999
        if (i==len(time[:])-1): #stop loop when reach the last data point in the time series
            fin_index=i+1
            i=99999
        i=i+1

    #restrict range based on start and end indices found above   
    time=time[strt_index:fin_index]
    val=val[strt_index:fin_index]  

    #return time and isotope values, respectively
    return (time,val)
    
   
    ##############################